/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "DX_VOS_File.h"
#include "DX_VOS_String.h"
#include "DX_VOS_Stdio.h"
#include "drmcommon.h"
#include "drmcrt.h"
#include "logger.h"
#ifdef WINCE_TEST
#include <windows.h>
#include <tchar.h>
#include <winbase.h>
#endif
 
  
static DRM_BOOL _fLoggerEnabled = FALSE;

void Log(char *szTag, char *szMessage, ...)
{
#if !defined(DX_CC5_SEP_PLAT) && !defined(__unix__)
	va_list va;
	va_start(va, szMessage);
	vLog(szTag, szMessage, va);
	va_end(va);
#endif
}
/*for COM LOG version*/
#ifdef USE_DRM_HARNESS_LOGGER

#ifndef _WIN32_WINNT
	#define _WIN32_WINNT 0x0400
#endif

#include <objbase.h>

#define COBJMACROS

#include "harnesslogmanager.h"
#include "harnesslogmanager_i.c"

static IHarnessManager *g_pLogger = NULL;

IHarnessManager* GetLogger()
{
	if (_fLoggerEnabled && !g_pLogger) {
		HRESULT hr;
		if (FAILED(hr = CoCreateInstance(&CLSID_HarnessManager, NULL, CLSCTX_SERVER, &IID_IHarnessManager, (void**)&g_pLogger))) {
			DX_VOS_Printf("Fail to create Harness Logger. hr=0X%X\n", hr);
		}
	}
	return g_pLogger;		
}

static BSTR A2BSTR(char *s)
{
	BSTR bstrOut = NULL;
	WCHAR *ws = NULL;
	size_t sizeWs, sizeS;

	sizeS = strlen(s) + 1;
	sizeWs = OEM_mbstowcs(NULL, s, sizeS) + 1;
	if (ws = (WCHAR*)OEM_malloc(sizeWs * sizeof(WCHAR))) {
		OEM_mbstowcs(ws, s, sizeS);
		bstrOut = SysAllocString(ws);
		DX_VOS_MemFree(ws);
	}
	
	return bstrOut;
}

void InitLogger(DRM_BOOL fLoggerEnabled)
{
	if(_fLoggerEnabled = fLoggerEnabled)
		CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
}

void LogStart(long lTC)
{
	IHarnessManager *pLogger = GetLogger();
	if (pLogger)
		IHarnessManager_Start(pLogger, lTC);
	else
		DX_VOS_Printf("Start Test Case %d.\n", lTC);
}

void vLog(char *szTag, char *szMessage, va_list argptr)
{
	IHarnessManager *pLogger = GetLogger();
	if (szTag && szMessage) {
		if (pLogger) {
			BSTR bstrTag, bstrMessage;

			#define MAX_LOG_BUFFER_SIZE 800
			char szBuffer[MAX_LOG_BUFFER_SIZE];
			int len;
			
			len = DX_VOS_VSPrintf(szBuffer, MAX_LOG_BUFFER_SIZE, szMessage, argptr);
			if (len < 0 || len >= MAX_LOG_BUFFER_SIZE)
				szBuffer[MAX_LOG_BUFFER_SIZE - 1] = 0;

			bstrTag = A2BSTR(szTag);
			bstrMessage = A2BSTR(szBuffer);

			IHarnessManager_Set(pLogger, bstrTag, bstrMessage);
		
			SysFreeString(bstrTag);
			SysFreeString(bstrMessage);
		} else {
			DX_VOS_Printf("\t%s: ", szTag);
			DX_VOS_VPrintf(szMessage, argptr);
			DX_VOS_Printf("\n");
		}
	}
}

void LogEnd(int fPass, char *szMessage,char *szTrace)
{
	IHarnessManager *pLogger = GetLogger();
	if (pLogger) {
		BSTR bstrMessage = A2BSTR(szMessage);
		IHarnessManager_LogResult(pLogger, fPass, bstrMessage);
		IHarnessManager_End(pLogger);
		SysFreeString(bstrMessage);
	} else {
		DX_VOS_Printf("Test Result: %s: %s\n", fPass? "Pass":"FAIL", szMessage);
	}
}

void UninitLogger()
{
	if (g_pLogger) {
		IHarnessManager_Release(g_pLogger);
		g_pLogger = NULL;
		CoUninitialize();
	}
}

#else

/*for wince version and ANSI version*/
DxVosFile fpLog;
char g_szExeNameWithExtension[256];

/* log to text file */
void LogStart(long lTC)
{
	char szLogMessage[500]={0};
	DX_VOS_SPrintf(szLogMessage,sizeof(szLogMessage) ,"<LOGRESULTS CaseNo=\"%d\" ", lTC);
	DX_VOS_Printf("Start test case=%ld", lTC);
	DX_VOS_FWrite(fpLog,szLogMessage,DX_VOS_StrLen(szLogMessage));
}

/*only print out the results*/
void vLog(char *szTag, char *szMessage, va_list argptr)
{
	if (szTag && szMessage) {
		DX_VOS_Printf("\t%s: ", szTag);
		DX_VOS_VPrintf(szMessage, (DX_VA_LIST)&argptr);
		DX_VOS_Printf("\n");
	}
}

void LogEnd(int fPass, char *szTitle, char *szTrace)
{
	char szLogMessage[500]={0};

	/* If the test cases failed, log the result */
	DX_VOS_MemSet(szLogMessage, 0, sizeof(szLogMessage));
	DX_VOS_SPrintf(szLogMessage,sizeof(szLogMessage), "Result=\"%s\">\n", fPass? "PASS":"FAIL");
	DX_VOS_Printf("Result=\"%s\">\n", fPass? "PASS":"FAIL");
	DX_VOS_FWrite(fpLog,szLogMessage,DX_VOS_StrLen(szLogMessage));
	if(szTitle!=NULL){
		DX_VOS_MemSet(szLogMessage, 0, sizeof(szLogMessage));
		DX_VOS_SPrintf(szLogMessage,sizeof(szLogMessage), "<Title>%s</Title>\n", szTitle); 
		DX_VOS_Printf("<Title>%s</Title>\n", szTitle);
		DX_VOS_FWrite(fpLog,szLogMessage,DX_VOS_StrLen(szLogMessage));
	}
	if(szTrace!=NULL){
		DX_VOS_MemSet(szLogMessage, 0, sizeof(szLogMessage));
		DX_VOS_SPrintf(szLogMessage, sizeof(szLogMessage), "<Trace>%s</Trace>\n", szTrace); 
		DX_VOS_Printf("<Trace>%s</Trace>\n", szTrace);
		DX_VOS_FWrite(fpLog,szLogMessage,DX_VOS_StrLen(szLogMessage));
	}
	DX_VOS_FWrite(fpLog,"</LOGRESULTS>\n",DX_VOS_StrLen("</LOGRESULTS>\n"));
 
}

/* create a log file. If there is an existed one from previous run, delete it */
void InitLogger(DRM_BOOL fLoggerEnabled)
{
 	char szExeNameWithoutExtension[256]={0};
	char szFullPath[256]={0};
	int iLen=0;
#ifdef WINCE_TEST
	DRM_WCHAR wszPath[256]={0},wszTempPath[256]={0};
	/*GetModuleFileName(NULL,wszTempPath,256);*/
	OEM_mbstowcs(wszTempPath,g_szExeNameWithExtension,256);
	 
	iLen=DRM_wcslen(wszTempPath);
	if(OEM_wcsstr(wszTempPath,L".exe")||OEM_wcsstr(wszTempPath,L".Exe")||OEM_wcsstr(wszTempPath,L".EXE"))
		DRM_wcsncpy(wszPath, wszTempPath,iLen-4);
 	else
		OEM_wcscpy(wszPath,wszTempPath);
	OEM_wcscat(wszPath, L".xml");
	OEM_wcstombs(szFullPath,wszPath,DRM_wcslen(wszPath)+1);
#else 
	/*remove the .exe extension*/
	iLen=DX_VOS_StrLen(g_szExeNameWithExtension);
	if(DX_VOS_FindStr(g_szExeNameWithExtension,".exe")||DX_VOS_FindStr(g_szExeNameWithExtension,".Exe")||DX_VOS_FindStr(g_szExeNameWithExtension,".EXE")){
		iLen=DX_VOS_StrLen(g_szExeNameWithExtension);
		/*Copy the file name without extension - differ from original strncpy*/
		DX_VOS_StrNCopy(szExeNameWithoutExtension,iLen-3, g_szExeNameWithExtension);
	}
	else
		/*Copy the file name without extension - differ from original strncpy*/
		DX_VOS_StrNCopy(szExeNameWithoutExtension,sizeof(g_szExeNameWithExtension) + 1,g_szExeNameWithExtension);
	
 	DX_VOS_SPrintf(szFullPath,sizeof(szFullPath),"%s.xml",szExeNameWithoutExtension);
#endif

	/*delete the old file if there is any one*/
 	DX_VOS_FOpen(&fpLog,szFullPath, "w+");
	if(fpLog)
		DX_VOS_FClose(fpLog);
	/*open for appending mode*/ 
 	DX_VOS_FOpen(&fpLog,szFullPath, "w+");
	DX_VOS_FWrite(fpLog,"<LOGSUMMARY>",DX_VOS_StrLen("<LOGSUMMARY>"));
}


/*close the file*/
void UninitLogger()
{
	if (fpLog){
		DX_VOS_FWrite(fpLog,"</LOGSUMMARY>\n",DX_VOS_StrLen("</LOGSUMMARY>\n"));
		DX_VOS_FClose(fpLog);
	}
}

#endif 
 
